// ignore_for_file: must_be_immutable

import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:nb_utils/nb_utils.dart';
import 'package:streamit_laravel/components/cached_image_widget.dart';
import 'package:streamit_laravel/generated/assets.dart';
import 'package:streamit_laravel/main.dart';
import 'package:streamit_laravel/screens/auth/sign_in/sign_in_screen.dart';
import 'package:streamit_laravel/screens/movie_details/model/movie_details_resp.dart';

import '../../../components/custom_icon_button_widget.dart';
import '../../../utils/app_common.dart';
import '../../../utils/colors.dart';
import '../../../utils/common_base.dart';
import '../../../utils/constants.dart';
import '../../review_list/components/remove_review_component.dart';
import '../movie_details_controller.dart';
import 'actor_component.dart';
import 'add_review/add_review_component.dart';
import 'more_list/more_list_component.dart';
import 'review_list/review_list_component.dart';

class MovieDetailsComponent extends StatelessWidget {
  final MovieDetailModel movieDetail;

  final MovieDetailsController movieDetCont;

  const MovieDetailsComponent({super.key, required this.movieDetail, required this.movieDetCont});

  @override
  Widget build(BuildContext context) {
    return Obx(
      () => Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        mainAxisAlignment: MainAxisAlignment.start,
        children: [
          Wrap(
            spacing: 12,
            children: [
              CustomIconButton(
                icon: Assets.iconsIcPlus,
                color: Colors.white38,
                onTap: () {
                  if (isLoggedIn.isTrue) {
                    movieDetCont.saveWatchList(addToWatchList: !movieDetail.isWatchList);
                  } else {
                    Get.to(() => SignInScreen())?.then((value) {
                      if (isLoggedIn.isTrue) {
                        movieDetCont.saveWatchList(addToWatchList: !movieDetail.isWatchList);
                      }
                    });
                  }
                },
                isTrue: movieDetail.isWatchList,
                checkIcon: Assets.iconsIcCheck,
              ),
              CustomIconButton(
                  icon: Assets.iconsIcShare,
                  onTap: () {
                    shareVideo(type: VideoType.movie, videoId: movieDetail.id);
                    // viewFiles(movieDetail.name);
                  }),
              if (movieDetCont.showDownload.isTrue)
                Obx(
                  () {
                    if (movieDetCont.downloadPercentage.value >= 1 && movieDetCont.downloadPercentage.value < 100) {
                      return Container(
                        height: 42,
                        width: 42,
                        padding: EdgeInsets.all(4),
                        decoration: boxDecorationDefault(
                          color: circleColor,
                          shape: BoxShape.circle,
                        ),
                        alignment: Alignment.center,
                        child: Marquee(
                          child: Text(
                            '${movieDetCont.downloadPercentage.value}'.suffixText(value: '%'),
                            style: primaryTextStyle(color: appColorPrimary),
                          ),
                        ),
                      ).visible(movieDetCont.showDownload.value);
                    } else {
                      return Obx(() {
                        return CustomIconButton(
                          icon: movieDetCont.isDownloaded.value ? Assets.iconsIcDelete : Assets.iconsIcDownload,
                          color: Colors.white54,
                          onTap: () async {
                            if (movieDetCont.isDownloaded.value || movieDetail.requiredPlanLevel == 0) {
                              movieDetCont.handleDownloads();
                            } else {
                              onSubscriptionLoginCheck(
                                videoAccess: movieDetail.movieAccess,
                                callBack: () {
                                  if (currentSubscription.value.level >= movieDetCont.movieDetailsResp.value.requiredPlanLevel) {
                                    movieDetCont.handleDownloads();
                                  }
                                },
                                planId: movieDetail.planId,
                                planLevel: movieDetail.requiredPlanLevel,
                              );
                            }
                          },
                        );
                      });
                    }
                  },
                ),
              CustomIconButton(
                icon: Assets.iconsIcThumbsup,
                onTap: () {
                  doIfLogin(
                    onLoggedIn: () {
                      if (isLoggedIn.isTrue) {
                        MovieDetailsController movieDetCont = Get.find();
                        movieDetCont.addLike();
                      }
                    },
                  );
                },
                isTrue: movieDetail.isLike,
                checkIcon: Assets.iconsIcLike,
              ),
              CustomIconButton(
                icon: Assets.iconsIcPictureInPicture,
                color: Colors.grey,
                onTap: () async {
                  /// Handle Picture In Picture Mode
                  handlePip(controller: movieDetCont, context: context);
                },
              ),
            ],
          ).paddingSymmetric(vertical: 16, horizontal: 2),
          ActorComponent(castDetails: movieDetail.casts, title: locale.value.cast),
          ActorComponent(castDetails: movieDetail.directors, title: locale.value.directors),
          AddReviewComponent(
            isMovie: true,
            editReviewCallback: () {
              movieDetCont.editReview();
            },
            deleteReviewCallback: () {
              LiveStream().emit(podPlayerPauseKey);
              Get.bottomSheet(
                isDismissible: true,
                isScrollControlled: false,
                RemoveReviewComponent(
                  onRemoveTap: () {
                    Get.back();
                    LiveStream().emit(podPlayerPauseKey);
                    movieDetCont.deleteReview();
                  },
                ),
              );
            },
          ).visible(isLoggedIn.isTrue),
          ReviewListComponent(
            reviewList: movieDetail.reviews,
            movieName: movieDetail.name,
            movieId: movieDetail.id,
            isMovie: true,
          ).visible(movieDetail.reviews.isNotEmpty),
          MoreListComponent(moreList: movieDetail.moreItems).visible(movieDetail.moreItems.isNotEmpty),
        ],
      ),
    );
  }

  Widget commonType({required String icon, required Function() onTap}) {
    return InkWell(
      onTap: onTap,
      child: Container(
        padding: const EdgeInsets.all(11),
        decoration: boxDecorationDefault(
          color: circleColor,
          shape: BoxShape.circle,
        ),
        child: CachedImageWidget(
          url: icon,
          height: 18,
          width: 18,
        ),
      ),
    );
  }
}
